/*
 * I_fc_usb_tcu_JSONParser.cpp
 *
 *  Created on: Mar 19, 2015
 *      Author: kl81hc
 */


#include "I_fc_usb_tcu_JSONParser.h"

#include "fc_usb_tcu_trace_classes.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_USB_TCU_JSON_PARSER
#include "trcGenProj/Header/fc_usb_tcu_JSONParser.cpp.trc.h"
#endif

tInt I_fc_usb_tcu_JSONParser::tIntGetFID(Json::Value & root)
{
	bpstl::string strFid;
//	tBool boolGetString =
	jsonUtils.getString(root, json_utils::FID, strFid);
	tUInt iFid = 0;
	sscanf(strFid.c_str(), "0x%x", &iFid);

	return iFid;
}

I_fc_usb_tcu_JSONParser::~I_fc_usb_tcu_JSONParser()
{

}

tBool I_fc_usb_tcu_JSONParser::bParseLocation(Json::Value& root, T_tcu_Location& oLocation)
{
	tBool bIsParsingSuccess = FALSE;
	/*####### START LOCATION UPDATE ########*/

	//Location - Direction
	tU8 u8Direction = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::U8_DIRECTION, u8Direction);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oLocation.u8Direction = u8Direction;

	//Location - Longitude degree
	tU8 u8Longitude_Degree = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::U8_LONGITUDE_DEGREE, u8Longitude_Degree);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oLocation.u8Longitude_Degree = u8Longitude_Degree;

	//Location - Longitude minute
	tU8 u8Longitude_minute = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::U8_LONGITUDE_MINUTE, u8Longitude_minute);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oLocation.u8Longitude_minute = u8Longitude_minute;

	//Location - Longitude second
	tU16 u16Longitude_second = 0;
	bIsParsingSuccess = jsonUtils.gettU16UInt(root, json_utils::U16_LONGITUDE_SECOND, u16Longitude_second);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oLocation.u16Longitude_second = u16Longitude_second;

	//Location - Latitude degree
	tU8 u8Latitude_degree = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::U8_LATITUDE_DEGREE, u8Latitude_degree);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oLocation.u8Latitude_degree = u8Latitude_degree;

	//Location - Latitude minute
	tU8 u8Latitude_minute = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::U8_LATITUDE_MINUTE, u8Latitude_minute);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oLocation.u8Latitude_minute = u8Latitude_minute;

	//Location - Latitude second
	tU16 u16Latitude_second = 0;
	bIsParsingSuccess = jsonUtils.gettU16UInt(root, json_utils::U16_LATITUDE_SECOND, u16Latitude_second);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oLocation.u16Latitude_second = u16Latitude_second;

	/*####### LOCATION UPDATE FINISH ########*/
	return bIsParsingSuccess;
}

tBool I_fc_usb_tcu_JSONParser::bParseDataRecord(Json::Value root, T_tcu_Data_Record& oDataRecord)
{
	tBool bIsParsingSuccess = FALSE;

	//POI name
	bpstl::string strPOIName;
	bIsParsingSuccess = jsonUtils.getString(root, json_utils::CONNECTED_SEARCH_STR_POI_NAME, strPOIName);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oDataRecord.strPOIName = strPOIName;

	//Get Location JSON message
	Json::Value jLocation;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::LOCATION, jLocation);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	bIsParsingSuccess = bParseLocation(jLocation, oDataRecord.Location);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//Street Address
	bpstl::string strAddress;
	bIsParsingSuccess = jsonUtils.getString(root, json_utils::CONNECTED_SEARCH_STR_ADDRESS, strAddress);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oDataRecord.strAddress = strAddress;

	//Phone Number
	bpstl::string strPhoneNumber;
	bIsParsingSuccess = jsonUtils.getString(root, json_utils::CONNECTED_SEARCH_STR_PHONE_NUMBER, strPhoneNumber);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oDataRecord.strPhoneNumber = strPhoneNumber;

	//Phone Number For Disp
	bpstl::string strPhoneNumberForDisp;
	bIsParsingSuccess = jsonUtils.getString(root, json_utils::CONNECTED_SEARCH_STR_PHONE_NUMBER_FOR_DISP, strPhoneNumberForDisp);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oDataRecord.strPhoneNumberForDisp = strPhoneNumberForDisp;

	//Category
	bpstl::string strCategory;
	bIsParsingSuccess = jsonUtils.getString(root, json_utils::CONNECTED_SEARCH_STR_CATEGORY, strCategory);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oDataRecord.strCategory = strCategory;

	return bIsParsingSuccess;
}
tBool I_fc_usb_tcu_JSONParser::bParseConnectedSearchJSON(Json::Value& root, T_tcu_connected_search_result& oConnectedSearch)
{
	ETG_TRACE_USR2(("<< parseConnectedSearchJSON"));
	tBool bIsParsingSuccess = FALSE;

	//Get Connected Search JSON message
	Json::Value jConnectedSearch;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::CONNECTED_SEARCH, jConnectedSearch);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//Get the number of POIs
	tU8 u8NumOfPOI = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jConnectedSearch, json_utils::CONNECTED_SEARCH_U8_NUM_OF_POI, u8NumOfPOI);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oConnectedSearch.ConnectedSearch.u8NumOfPOI = u8NumOfPOI;


	//Get Data Record JSON message
	Json::Value jDataRecord;
	bIsParsingSuccess = jsonUtils.getJSONArray(jConnectedSearch, json_utils::CONNECTED_SEARCH_DATA_RECORD, jDataRecord);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//Resize
	oConnectedSearch.ConnectedSearch.DataRecord.resize(jDataRecord.size());

	//Update DataRecord structure for each POI
	for (tC16 i = 0; i < jDataRecord.size(); i++)
	{
		bIsParsingSuccess = bParseDataRecord(jDataRecord[i], oConnectedSearch.ConnectedSearch.DataRecord[i]);
		if(!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
	}
	return bIsParsingSuccess;
}

tBool I_fc_usb_tcu_JSONParser::bParseDataConnectionError(Json::Value& root, tU16& u16DataConnectionError, tU16& u16ErrorRequestType)
{
	ETG_TRACE_USR4(("<< vParseDataConnectionError"));
	tBool bIsParsingSuccess = FALSE;

	//Get the number of DataConnectionError.
	tU16 in_u16DataConnectionError = 0;
	bIsParsingSuccess = jsonUtils.gettU16UInt(root, json_utils::DATA_CONNECTION_ERROR, in_u16DataConnectionError);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	u16DataConnectionError = in_u16DataConnectionError;

	//Get the number of ErrorRequestType.
	tU16 in_u16ErrorRequestType = 0;
#if defined(VARIANT_S_FTR_ENABLE_FC_USB_TCU_PRC) || defined(VARIANT_S_FTR_ENABLE_FC_USB_TCU_EV) || defined(VARIANT_S_FTR_ENABLE_FC_USB_TCU_JPN)
//	bIsParsingSuccess = jsonUtils.gettU16UInt(root, json_utils::ERROR_REQUEST_TYPE, in_u16ErrorRequestType);
//	if(!bIsParsingSuccess)
//	{
//		return bIsParsingSuccess;
//	}
#endif
	u16ErrorRequestType = in_u16ErrorRequestType;

	return bIsParsingSuccess;
}

tBool I_fc_usb_tcu_JSONParser::bParseDTCConnectionStatus(Json::Value& root, tBool bDTCConnectionStatus)
{
	tBool bIsParsingSuccess = FALSE;

	tBool in_bDTCConnectionStatus = false;
	bIsParsingSuccess = jsonUtils.gettBool(root, json_utils::DTC_CONNECTION_STATUS, in_bDTCConnectionStatus);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	bDTCConnectionStatus = in_bDTCConnectionStatus;

	return bIsParsingSuccess;
}

tBool I_fc_usb_tcu_JSONParser::bParseServerListJSON(Json::Value& root, T_tcu_Server_Info_List& oServerInfoList)
{
	ETG_TRACE_USR2(("<< parseServerListJSON"));
	tBool bIsParsingSuccess = FALSE;

	//Get the server list Information
	//#####################################
	Json::Value jServerList;
	bIsParsingSuccess = jsonUtils.getJSONArray(root, json_utils::SERVER_LIST, jServerList);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//Resize
	oServerInfoList.ServerInfoList.resize(jServerList.size());

	//Update the server list
	for (unsigned int i=0; i < jServerList.size(); i++)
	{
		/*Copy ServerId*/
		tU8 u8ServerId = 0;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jServerList[i], json_utils::SERVER_LIST_U8_SERVER_ID, u8ServerId);
		if(!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		oServerInfoList.ServerInfoList[i].u8ServerId = u8ServerId;

		/*Copy ServerName*/
		bpstl::string  strServerName;
		bIsParsingSuccess = jsonUtils.getString(jServerList[i], json_utils::SERVER_LIST_STR_SERVER_NAME, strServerName);
		if(!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		oServerInfoList.ServerInfoList[i].strServerName = strServerName;

		/*Copy ServerAddress*/
		bpstl::string  strServerAddress;
		bIsParsingSuccess = jsonUtils.getString(jServerList[i], json_utils::SERVER_LIST_STR_SERVER_ADDRESS, strServerAddress);
		if(!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		oServerInfoList.ServerInfoList[i].strServerAddress = strServerAddress;
	}

	tU8 u8ActiveServerId = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::SERVER_LIST_U8_CURRENT_SERVER, u8ActiveServerId);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oServerInfoList.u8ActiveServerId = u8ActiveServerId;

	return bIsParsingSuccess;
}

tBool I_fc_usb_tcu_JSONParser::bParseDataConnectionStatus(Json::Value& root, T_e8_tcu_DataConnectionStatus& oDataConnectionStatus)
{
	ETG_TRACE_USR4(("<< bParseDataConnectionStatus"));
	tBool bIsParsingSuccess = FALSE;

	//Get the number of DataConnectionStatus.
	tU8 in_u8DataConnectionStatus = T_e8_tcu_DataConnectionStatus::USB_TCU_DATA_CONNECTION_STATUS_DISCONNECTED;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::DATA_CONNECTION_STATUS, in_u8DataConnectionStatus);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oDataConnectionStatus.enType = T_e8_tcu_DataConnectionStatus::tenType(in_u8DataConnectionStatus);

	return bIsParsingSuccess;
}

tBool I_fc_usb_tcu_JSONParser::bParseGeneralNotificationMessage(Json::Value& root, T_tcu_GeneralNotificationMessage& oGeneralNotificationMessage)
{
	ETG_TRACE_USR2(("<< bParseGeneralNotificationMessage"));
	tBool bIsParsingSuccess = false;
	Json::Value jGeneralNotificationMessage;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::GENERAL_NOTIFICATION_MESSAGE, jGeneralNotificationMessage);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	bIsParsingSuccess = jsonUtils.getString(jGeneralNotificationMessage, json_utils::STR_DISPLAY_MESSAGE, oGeneralNotificationMessage.strDisplayMessage);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	bIsParsingSuccess = jsonUtils.getString(jGeneralNotificationMessage, json_utils::STR_TTS_TEXT_MESSAGE, oGeneralNotificationMessage.strTTSTextMessage);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	tU8 u8Result = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jGeneralNotificationMessage, json_utils::U8_NOTI_RESULT, u8Result);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	else
	{
		oGeneralNotificationMessage.u8Result = T_e8_tcu_NotiResult::tenType(u8Result);
	}
	return bIsParsingSuccess;
}

tBool I_fc_usb_tcu_JSONParser::bParseIconDataMessage(Json::Value& root, T_tcu_IconList& oIconList)
{
	ETG_TRACE_USR2(("<< bParseIconDataMessage"));
	tBool bIsParsingSuccess = false;
	Json::Value jIconDataMessage;
	bIsParsingSuccess = jsonUtils.getJSONArray(root, json_utils::ICON_LIST, jIconDataMessage);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//Resize
	oIconList.IconInfo.resize(jIconDataMessage.size());

	//Update the server list
	for (unsigned int i=0; i < jIconDataMessage.size(); i++)
	{
		/*Copy Icon ID*/
		tU16 u16IconID = 0;

		bIsParsingSuccess = jsonUtils.gettU16UInt(jIconDataMessage[i], json_utils::ICON_ID, u16IconID);
		if(!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		oIconList.IconInfo[i].u16IconID = u16IconID;

		/*Copy Icon Data Type*/
		tU8 u8IconDataType = 0;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jIconDataMessage[i], json_utils::ICON_DATA_TYPE, u8IconDataType);
		if(!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		oIconList.IconInfo[i].e8IconDataType = T_e8_tcu_IconDataType::tenType(u8IconDataType);

		/*Copy IconForMapDaytime*/
		bIsParsingSuccess = jsonUtils.getString(jIconDataMessage[i], json_utils::ICON_FOR_MAP_DAY_TIME, oIconList.IconInfo[i].strIconForMapDaytime);
		if(!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}

		/*Copy IconForMenuDaytime*/
		bIsParsingSuccess = jsonUtils.getString(jIconDataMessage[i], json_utils::ICON_FOR_MENU_DAY_TIME, oIconList.IconInfo[i].strIconForMenuDaytime);
		if(!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}

		/*Copy IconForMapNight*/
		bIsParsingSuccess = jsonUtils.getString(jIconDataMessage[i], json_utils::ICON_FOR_MAP_NIGHT, oIconList.IconInfo[i].strIconForMapNight);
		if(!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}

		/*Copy IconForMenuNight*/
		bIsParsingSuccess = jsonUtils.getString(jIconDataMessage[i], json_utils::ICON_FOR_MENU_NIGHT, oIconList.IconInfo[i].strIconForMenuNight);
		if(!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}

	}

	return bIsParsingSuccess;
}

tBool I_fc_usb_tcu_JSONParser::bGetItems(Json::Value & root,Json::Value &jItemList)
{

	tBool bIsParsingSuccess = jsonUtils.getJSONArray(root, json_utils::RESPONSE_LIST, jItemList);
	return bIsParsingSuccess;

}

tBool I_fc_usb_tcu_JSONParser::bParseGeneralResponse(Json::Value& root, T_tcu_GeneralResponse& oGeneralResponseMessage)
{
	ETG_TRACE_USR4(("<< I_fc_usb_tcu_JSONParser::bParseGeneralResponse"));
	tBool bIsParsingSuccess = FALSE;
	Json::Value jGenaralResponse;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::GENERAL_RESPONSE, jGenaralResponse);
	if(TRUE == bIsParsingSuccess)
	{
		ETG_TRACE_USR4(("TRUE == bIsParsingSuccess"));
		tU16 u16RequestID;
		bIsParsingSuccess =  jsonUtils.gettU16UInt(jGenaralResponse, json_utils::REQUEST_ID,u16RequestID);
		if(TRUE == bIsParsingSuccess)
		{
			oGeneralResponseMessage.u16RequestID = (T_e16_tcu_GenRes_RequestId::tenType)u16RequestID;
		}
		else
		{
			return bIsParsingSuccess;
		}

		tU8 u8ResponseID;
		bIsParsingSuccess =  jsonUtils.gettU8UInt(jGenaralResponse, json_utils::RESPONSE_ID,u8ResponseID);
		if(TRUE == bIsParsingSuccess)
		{
			oGeneralResponseMessage.u8ResponseID = (T_e8_tcu_GenRes_ResponseId::tenType)u8ResponseID;
		}
		else
		{
			return bIsParsingSuccess;
		}

	}
	ETG_TRACE_USR4((">> I_fc_usb_tcu_JSONParser::bParseGeneralResponse"));
	return bIsParsingSuccess;
}

tBool I_fc_usb_tcu_JSONParser::bParseCarwingsDate(Json::Value & root, T_tcu_carwings_date& oCarwingsDate)
{
	tBool bIsParsingSuccess = FALSE;

	//Date - Year
	tU16 u16Year = 0;
	bIsParsingSuccess = jsonUtils.gettU16UInt(root, json_utils::U16_YEAR, u16Year);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oCarwingsDate.u16Year = u16Year;

	//Date - Month
	tU8 u8Month = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::U8_MONTH, u8Month);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oCarwingsDate.u8Month = u8Month;

	//Date - Day
	tU8 u8Day = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::U8_DAY, u8Day);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oCarwingsDate.u8Day = u8Day;

	//Date - Hour
	tU8 u8Hour = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::U8_HOUR, u8Hour);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oCarwingsDate.u8Hour = u8Hour;

	//Date - Minutes
	tU8 u8Minutes = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::U8_MINUTES, u8Minutes);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oCarwingsDate.u8Minutes = u8Minutes;

	return bIsParsingSuccess;
}
